﻿using System;
using System.Collections.Generic;

// Listing 4-27. Implementacja interfejsu IClockIn
class FireStation : IClockIn
{
    List<INamedPerson> clockedInStaff = new List<INamedPerson>();
    public void ClockIn(INamedPerson staffMember)
    {
        if (!clockedInStaff.Contains(staffMember))
        {
            clockedInStaff.Add(staffMember);
            Console.WriteLine("{0} się zarejestrował.", staffMember.Name);
        }
    }
    public void RollCall()
    {
        foreach (INamedPerson staffMember in clockedInStaff)
        {
            Console.WriteLine(staffMember.Name);
        }
    }

    // Alternatywa 1:
    //public void ClockIn(object item)
    //{
    //    if (item is INamedPerson)
    //    {
    //        ClockIn(item as INamedPerson);
    //    }
    //    else
    //    {
    //        Console.WriteLine("Nie można zarejestrować '{0}'.", item.GetType());
    //    }
    //}

    // Alternatywa 2:
    public void ClockIn(object item)
    {
        INamedPerson namedPerson = item as INamedPerson;
        if (namedPerson != null)
        {
            ClockIn(namedPerson);
        }
        else
        {
            Console.WriteLine("Nie można zarejestrować '{0}'.", item.GetType());
        }
    }
}